module RPG
  class Event::Page
    def initialize
      @condition = RPG::Event::Page::Condition.new
      @graphic = RPG::Event::Page::Graphic.new
      @move_type = 0
      @move_speed = 3
      @move_frequency = 3
      @move_route = RPG::MoveRoute.new
      @walk_anime = true
      @step_anime = false
      @direction_fix = false
      @through = false
      @always_on_top = false
      @trigger = 0
      @list = [RPG::EventCommand.new]
    end
    attr_accessor :condition
    attr_accessor :graphic
    attr_accessor :move_type
    attr_accessor :move_speed
    attr_accessor :move_frequency
    attr_accessor :move_route
    attr_accessor :walk_anime
    attr_accessor :step_anime
    attr_accessor :direction_fix
    attr_accessor :through
    attr_accessor :always_on_top
    attr_accessor :trigger
    attr_accessor :list
  end



  class Event::Page

    

    def to_dmk(numero)
      my = My_RPG::My_Page.new(numero)

      my.condition = @condition
      my.graphic = @graphic
      my.move_type = @move_type
      my.move_speed = @move_speed
      my.move_frequency = @move_frequency
      my.move_route = @move_route.to_dmk
      my.walk_anime = @walk_anime
      my.step_anime = @step_anime
      my.direction_fix = @direction_fix
      my.through = @through
      my.always_on_top = @always_on_top
      my.trigger = @trigger


      for command in @list
        com_dmk = command.to_dmk

        if com_dmk == nil
          #p command
          next
        end

        # On prcise l'indentation
        my.add_indent(com_dmk, command.indent)
        com_dmk.page = my
        my.instructions << com_dmk
        #if command.code == CODE_MESSAGE
        #  if command.parameters != com_dmk.parameters
        #  p command, com_dmk
        #  raise
        #  end
        #end
      end

      # Rassemblement des instructions
      my.rassembler_instruction

      return my
    end


    def comparer(page)
      

      raise(DMKW_DMK_Diff.new("Page : parameter")) if @condition.comparer(page.condition) == false
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @graphic.comparer(page.graphic) == false
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @move_type != page.move_type
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @move_speed != page.move_speed
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @move_frequency != page.move_frequency
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @move_route.comparer(page.move_route) == false
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @walk_anime != page.walk_anime
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @step_anime != page.step_anime
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @direction_fix != page.direction_fix
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @through != page.through
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @always_on_top != page.always_on_top
      raise(DMKW_DMK_Diff.new("Page : parameter")) if @trigger != page.trigger

      #if @list != page.list
      #  if $debug != true then raise(DMKW_DMK_Diff.new("Page : parameter")) else raise "page.list" end
      #end


      #p @list, page.list
      #getz

      # On compare toutes les instructions
      if @list.size != page.list.size
        #p @list, page.list
        raise(DMKW_DMK_Diff.new("Page : list size"))
      end
      for i in 0...@list.size
        if @list[i].comparer(page.list[i]) == false
          #p @list[i], page.list[i]
          #p @list[i].parameters != page.list[i].parameters
          raise(DMKW_DMK_Diff.new("Page : list"))
        end
      end

      return true

    end


    def inspect2
      txt = "## PAGE ##\n"
      for instr in @list
        txt << instr.inspect2+"\n"
      end
      return txt
    end



  end


end
